# Icinga Knowledge Base - IWKB000016

## Short Message

Checks using Performance Counter fail with various messages like `Exception of type 'System.OutOfMemoryException' was thrown` or `Icinga Invalid Configuration Error was thrown: PerfCounterCategoryMissing: Category "Memory" not found`

## Example Exception

### Out-Of-Memory Exception

```powershell
[UNKNOWN]: Icinga Unhandled Error was thrown: Unhandled Exception

Unhandled exception occurred: System.Management.Automation.MethodInvocationException: Exception calling "GetInstanceNames" with "0" argument(s): "Exception of type 'System.OutOfMemoryException' was thrown." ---> System.OutOfMemoryException: Exception of type 'System.OutOfMemoryException' was thrown. at Microsoft.Win32.RegistryKey.InternalGetValue(String name, Object defaultValue, Boolean doNotExpand, Boolean checkSecurity) at Microsoft.Win32.RegistryKey.GetValue(String name) at System.Diagnostics.PerformanceMonitor.GetData(String item) at System.Diagnostics.PerformanceCounterLib.GetPerformanceData(String item) at System.Diagnostics.PerformanceCounterLib.get_CategoryTable() at System.Diagnostics.PerformanceCounterLib.GetCategorySample(String category) at System.Diagnostics.PerformanceCounterLib.GetCategorySample(String machine, String category) at System.Diagnostics.PerformanceCounterCategory.GetCounterInstances(String categoryName, String machineName) at CallSite.Target(Closure , CallSite , Object ) --- End of inner exception stack trace --- at System.Management.Automation.ExceptionHandlingOps.CheckActionPreference(FunctionContext funcContext, Exception exception) at System.Management.Automation.Interpreter.ActionCallInstruction`2.Run(InterpretedFrame frame) at System.Management.Automation.Interpreter.EnterTryCatchFinallyInstruction.Run(InterpretedFrame frame) at System.Management.Automation.Interpreter.EnterTryCatchFinallyInstruction.Run(InterpretedFrame frame)
```

### Category "..." not found

```powershell
[UNKNOWN]: Icinga Invalid Configuration Error was thrown: PerfCounterCategoryMissing: Category "Memory" not found

The specified Performance Counter category was not found on this system. This could either be a configuration error on your local Windows machine or a wrong usage of the plugin. Please check on different Windows machines if this issue persis. In case it only occurs on certain machines it is likely that the counter is simply not present and the plugin can not be processed.
```

## Reason

This issue seem only to appear while running Icinga for Windows **without** [JEA-Profile](../130-JEA/01-JEA-Profiles.md) and installed SCOM-Agent from Microsoft including the `APM` feature on the same machine.

The reason can be tracked back to the `Intercept Counters` which are installed together with SCOM and `APM` feature.

To check if you are affected by these counters, you can run the command `Test-IcingaInterceptCounter` starting with Icinga for Windows v1.11.0:

```powershell
PS> Test-IcingaInterceptCounter;

[Notice]: Testing for Microsoft SCOM Intercept Counters
[Failed]: Entry "HKLM:\SYSTEM\CurrentControlSet\Services\Intercept CSM Filters\Performance" is present on the system and the intercept counter is NOT disabled
[Passed]: Entry "HKLM:\SYSTEM\CurrentControlSet\Services\Intercept Injector\Performance" is not present on the system
[Passed]: Entry "HKLM:\SYSTEM\CurrentControlSet\Services\Intercept SyncAction Processing\Performance" is not present on the system
[Passed]: Entry "HKLM:\SYSTEM\CurrentControlSet\Services\InterceptCountersManager\Performance" is not present on the system
[Passed]: Entry "HKLM:\SYSTEM\CurrentControlSet\Services\Backup Exec\Performance" is not present on the system
[Failed]: One or more intercept counters exist on this system which are not disabled. Please take a look at https://icinga.com/docs/icinga-for-windows/latest/doc/knowledgebase/IWKB000016/ for further details
```

## Solution

If the command `Test-IcingaInterceptCounter` is reporting a `Failed` state on any of the tests, they are most likely the cause for issues regarding Performance Counter monitoring.

### Requiring APM Feature

Please check beforehand, if you are making use of any of the `Intercept Counters` installed with the SCOM-Agent in your environment. If you are using and requiring the `APM` feature provided by SCOM, the solution would be to reinstall the SCOM-Agent together with the `APM` feature, which should resolve the issue.

If the error persists after the reinstallation, please open a support case for SCOM with Microsoft.

### APM is not required

In case you are not using any of the `APM` features provided the SCOM-Agent, you are save to disable to `Intercept Counters`.

To disable these counters, you can run the command `Disable-IcingaInterceptCounter`:

```powershell
PS> Disable-IcingaInterceptCounter;

[Notice]: Disabling SCOM intercept counter "HKLM:\SYSTEM\CurrentControlSet\Services\Intercept CSM Filters\Performance"
[Notice]: SCOM intercept counter "HKLM:\SYSTEM\CurrentControlSet\Services\Intercept Injector\Performance" not installed on the system
[Notice]: SCOM intercept counter "HKLM:\SYSTEM\CurrentControlSet\Services\Intercept SyncAction Processing\Performance" not installed on the system
[Notice]: SCOM intercept counter "HKLM:\SYSTEM\CurrentControlSet\Services\InterceptCountersManager\Performance" not installed on the system
[Notice]: SCOM intercept counter "HKLM:\SYSTEM\CurrentControlSet\Services\InterceptCountersManager\Performance" not installed on the system
[Notice]: SCOM intercept counter "HKLM:\SYSTEM\CurrentControlSet\Services\Backup Exec\Performance" not installed on the system
```

Afterwards reboot your server and the monitoring with plugins using Performance Counter should be fine.

To enable the `Intercept Counters` again, you can run `Enable-IcingaInterceptCounter`:

```powershell
PS> Enable-IcingaInterceptCounter;

[Notice]: Enabling SCOM intercept counter "HKLM:\SYSTEM\CurrentControlSet\Services\Intercept CSM Filters\Performance"
[Notice]: SCOM intercept counter "HKLM:\SYSTEM\CurrentControlSet\Services\Intercept Injector\Performance" not installed on the system
[Notice]: SCOM intercept counter "HKLM:\SYSTEM\CurrentControlSet\Services\Intercept SyncAction Processing\Performance" not installed on the system
[Notice]: SCOM intercept counter "HKLM:\SYSTEM\CurrentControlSet\Services\InterceptCountersManager\Performance" not installed on the system
[Notice]: SCOM intercept counter "HKLM:\SYSTEM\CurrentControlSet\Services\InterceptCountersManager\Performance" not installed on the system
[Notice]: SCOM intercept counter "HKLM:\SYSTEM\CurrentControlSet\Services\Backup Exec\Performance" not installed on the system
```

Again, reboot your server afterwards to complete the changes.
