# Icinga Knowledge Base - IWKB000001

## Short Message

The user you are running this command as does not have permission to access the requested Cim-Object. To fix this, please add the user the Agent is running with to the "Remote Management Users" groups and grant access to the WMI branch for the Class/Namespace mentioned above and add the permission "Remote enable".

## Example Exception

[UNKNOWN]: Icinga Permission Error was thrown: CimInstance: Class: "MSFT_PhysicalDisk", Namespace: "root\Microsoft\Windows\Storage"

## Reason

To access WMI Objects by either `Get-WmiObject` or `Get-CimInstance` you will require to grant permissions to the user running the plugins to be allowed to fetch data from them. In general default system users should already inherit these permissions.

However, if you are running custom users like an AD user or local users you might require to grant additional permissions.

## Required Permissions

Each plugin should contain a section for WMI permissions in case the plugin fetches WMI data, to give a better understanding which WMI area is accessed and permissions are required. For most plugins, the default space is `Root\Cimv2`, but additional spaces might be required.

## Solution

In case you are running into this issue, you will have to grant permissions on the corresponding WMI path printed at the `Namespace` within the exception message or include the WMI path from the plugin permissions documentation. An example plugin would be [Invoke-IcingaCheckDiskHealth](https://icinga.com/docs/windows/latest/plugins/doc/plugins/20-Invoke-IcingaCheckDiskHealth/#permissions).

### Adding Permissions

#### Using UI configuration

There is a detailed description on the [Microsoft Docs](https://docs.microsoft.com/en-us/previous-versions/windows/it-pro/windows-server-2008-R2-and-2008/cc771551(v=ws.11)) available on how permissions for WMI are set. Please keep in mind that granting permissions to the `primary namespace` might not be enough and you will require to change the user permissions to apply for `This namespace and subnamespaces`.

#### Using PowerShell

To add permissions for WMI namespaces you can use our Icinga for Windows Cmdlets. Simply open a new PowerShell as `Administrator` and create a new Icinga Shell instance by typing `icinga -Shell`.
After the Icinga PowerShell Framework is loaded, we can use our Wmi permission Cmdlet:

```powershell
Add-IcingaWmiPermissions -User 'icinga' -Namespace 'root\Microsoft\Windows\Storage' -Enable -RemoteAccess -Recurse;
```

The above command will grant the user `icinga` the read and remote access permission for the `root\Microsoft\Windows\Storage` namespace. In addition by using `-Recurse` we will set the permissions for `subnamespaces` in addition.

To fully apply the changes, it might be required to restart the Wmi service `Winmgmt`. How ever, you are running a Hyper-V server for example, the command

```powershell
Restart-Service Winmgmt;
```

might return an error, because this service has dependencies for other services. To enforce this, you can run

```powershell
Restart-Service Winmgmt -Force;
```

which will restart this and all other depending services. Please ensure that this is done while doing maintenance on the systems to not interrupt production services.

### Permission Table

| Flag           | Description |
| ---            | ---         |
| Enable         | Enables the account and grants the user read permissions. This is a default access right for all users and corresponds to the Enable Account permission on the Security tab of the WMI Control. For more information, see Setting Namespace Security with the WMI Control. |
| MethodExecute  | Allows the execution of methods. Providers can perform additional access checks. This is a default access right for all users and corresponds to the Execute Methods permission on the Security tab of the WMI Control. |
| FullWrite      | Allows a user account to write to classes in the WMI repository as well as instances. A user cannot write to system classes. Only members of the Administrators group have this permission. WBEM_FULL_WRITE_REP corresponds to the Full Write permission on the Security tab of the WMI Control. |
| PartialWrite   | Allows you to write data to instances only, not classes. A user cannot write classes to the WMI repository. Only members of the Administrators group have this right. WBEM_PARTIAL_WRITE_REP corresponds to the Partial Write permission on the Security tab of the WMI Control. |
| ProviderWrite  | Allows writing classes and instances to providers. Note that providers can do additional access checks when impersonating a user. This is a default access right for all users and corresponds to the Provider Write permission on the Security tab of the WMI Control. |
| RemoteAccess   | Allows a user account to remotely perform any operations allowed by the permissions described above. Only members of the Administrators group have this right. WBEM_REMOTE_ACCESS corresponds to the Remote Enable permission on the Security tab of the WMI Control. |
| Subscribe      | Specifies that a consumer can subscribe to the events delivered to a sink. Used in IWbemEventSink::SetSinkSecurity. |
| Publish        | Specifies that the account can publish events to the instance of __EventFilter that defines the event filter for a permanent consumer. Available in wbemcli.h. |
| ReadSecurity   | The right to read the information in the objects security descriptor, not including the information in the system access control list (SACL). |
| WriteSecurity  | The right to modify the discretionary access control list (DACL) in the objects security descriptor. |

**Note:** By default the Cmdlet `Add-IcingaWmiPermissions` only has direct build-in support for `-Enable` and `-RemoteAccess`. To apply different permissions, you will have to use the `-Flags` argument and add the flags by their name as shown in the table.
